DECLARE @TERM_ST_DT  DATETIME = DATEADD(day,-90,getdate()),  
        @TERM_ED_DT  DATETIME = DATEADD(day,90,getdate()),  
        @PROJECT_ID  VARCHAR(20),  
        @DAY         DATETIME,  
        @I           INT = 0,  
        @WK          INT = 0,  
        @DW          INT = 0,  
        @OT          INT = 0,  
        @ST_DT       DATETIME,  
        @ED_DT       DATETIME  
        
  IF OBJECT_ID('tempdb..#HEAD ') IS NOT NULL                                                                          
    DROP TABLE #HEAD 
    
CREATE TABLE #HEAD  
(  
   WK         INT,  
   YM         VARCHAR(10),  
   DD         VARCHAR(10),  
   ST_DT      DATETIME,  
   ED_DT      DATETIME  
)  
WHILE @WK < 53  
   BEGIN  
      SET @DAY = DATEADD(WK, @WK, @TERM_ST_DT)  
      --  
      IF @DAY > @TERM_ED_DT  
         BREAK  
      --  
      INSERT INTO #HEAD  
           SELECT @WK+1,  
                  REPLACE(CONVERT(VARCHAR(7), @DAY, 120),'-','.'),  
                  'W' + CAST(dbo.ufn_DayToWeek(@DAY) AS VARCHAR) + '(' + CAST(DATEPART(D, @DAY) AS VARCHAR) + ')',  
                  @DAY,  
                  DATEADD(D, 6, @DAY)  
      --  
      SET @WK += 1  
   END  
   
   select * from #HEAD